set echo on
--autor: Radoslav Golian
--popis: Skript demonstruje modifikovatelne pohlady a ich pouzitie

-- nacitame inicializacne parametre
@params.sql

-- umoznime pouzitie inicializacnych parametrov
set define on

prompt Prihlasime sa ako pouzivatel &user_name

connect &user_name/&user_pass&db_name

prompt Vytvorime balik umoznujuci nastavenie aplikacneho kontextu
prompt Vytvorime specifikaciu
CREATE OR REPLACE PACKAGE sample_context_pkg IS
  PROCEDURE set_client_id(client_id IN NUMBER);
  PROCEDURE clear_client_id;
END sample_context_pkg;
/

prompt Vytvorime telo balika

CREATE OR REPLACE PACKAGE BODY sample_context_pkg IS
  PROCEDURE set_client_id(client_id IN NUMBER) IS
  BEGIN
    dbms_session.set_context(
      namespace => 'sample_context',
      attribute => 'client_id',
      value => client_id);
  END;
  PROCEDURE clear_client_id IS
  BEGIN
    dbms_session.clear_context(
      namespace => 'sample_context',
      attribute => 'client_id');
  END;
END sample_context_pkg;
/

prompt vytvorime tabulku transaction nad ktorou budeme demonstrovat pouzitie aplikacneho kontextu
create table transaction(id number primary key,
                         client_id number,
                         from_account varchar2(10),
                         to_account varchar2(10),
                         amount number(8,2),
                         notes varchar2(256)) tablespace USERS;

pause Pre pokracovanie stlacte Enter

prompt Vlozime do tabulu niekolko zaznamov
insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (1, 10, '5556667778', '9996663332', 5000, 'najomne za september');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (2, 10, '5556667778', '9996663332', 5000, 'najomne za oktober');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (3, 10, '5556667778', '9996663332', 10000, 'najomne za december');

insert into transaction(id, client_id, from_account, to_account, amount, notes)
values (4, 11, '0001112223', '0001112224', 10000, 'vypalne');

commit;

pause Pre pokracovanie stlacte Enter

CREATE CONTEXT sample_context USING &user_name .sample_context_pkg;

pause Pre pokracovanie stlacte Enter
Prompt Pred vykonanim dopytu nastavime atribut aplikacneho kontextu
EXECUTE sample_context_pkg.set_client_id(10);

-- sirka stlpca pre stlpec notes
column notes format a30

pause Pre pokracovanie stlacte Enter
prompt vykoname dopyt
SELECT * FROM transaction
WHERE client_id=sys_context('sample_context', 'client_id');

pause Pre pokracovanie stlacte Enter

Prompt Nastavime parameter client_id v kontexte na hodnotu 11
EXECUTE sample_context_pkg.set_client_id(11);

pause Pre pokracovanie stlacte Enter

Prompt vykoname dopyt
SELECT * FROM transaction
WHERE client_id=sys_context('sample_context', 'client_id');

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie

exit

